<?php 
    include "../../conn.php";
    include "../../functions2.php";

    header('Content-Type: application/json; charset=utf-8');
    header('Strict-Transport-Security: max-age=31536000');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Access-Control-Allow-Origin: ' . $origin);
    header('vary: Origin');

    date_default_timezone_set("Asia/Kolkata");
    $shnunc = date("Y-m-d H:i:s");
    $res = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $shnunc,
    ];

    try {
        $shonubody = file_get_contents("php://input");
        $shonupost = json_decode($shonubody, true);

        if ($_SERVER['REQUEST_METHOD'] != 'GET') {
            if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['timestamp'])) {
                $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
                $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
                $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
                $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
                $author = $bearer[1];				
                $is_jwt_valid = is_jwt_valid($author);
                $data_auth = json_decode($is_jwt_valid, 1);

                if ($data_auth['status'] === 'Success') {
                    $sesquery = "SELECT id, codechorkamukala FROM shonu_subjects WHERE akshinak = '$author'";
                    $sesresult = $conn->query($sesquery);
                    if ($sesresult->num_rows == 1) {
                        $user = $sesresult->fetch_assoc();
                        $userId = $user['id'];
                        $userCode = $user['codechorkamukala'];

                        // Call the withdraw API to transfer balance
                        try {
                            $withdrawResponse = withdrawUserBalance($userCode);
                            if ($withdrawResponse['success']) {
                                $withdrawAmount = $withdrawResponse['message']; // Amount withdrawn

                                // Update the user's balance in the motta column
                                $updateBalanceQuery = "UPDATE shonu_kaichila SET motta = motta + $withdrawAmount WHERE balakedara = '$userId'";
                                if ($conn->query($updateBalanceQuery) !== TRUE) {
                                    throw new Exception('Failed to update user balance in the database.');
                                }

                                // Prepare the response in the required format
                                $res = [
                                    'code' => 0,
                                    'msg' => 'Succeed',
                                    'msgCode' => 0,
                                    'serviceNowTime' => $shnunc,
                                    'data' => [
                                        'amount' => (string)$withdrawAmount,
                                        'uRate' => 93,
                                        'uGold' => 0
                                    ]
                                ];
                                http_response_code(200);
                                echo json_encode($res);
                            } else {
                                throw new Exception('Withdraw failed: ' . ($withdrawResponse['message'] ?? 'Unknown error'));
                            }
                        } catch (Exception $e) {
                            $res['code'] = 5;
                            $res['msg'] = 'Withdraw Error: ' . $e->getMessage();
                            $res['msgCode'] = 3;
                            http_response_code(500);
                            echo json_encode($res);
                            exit;
                        }
                    } else {
                        $res['code'] = 4;
                        $res['msg'] = 'No operation permission';
                        $res['msgCode'] = 2;
                        http_response_code(401);
                        echo json_encode($res);
                    }
                } else {					
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);					
                }
            } else {
                $res['code'] = 7;
                $res['msg'] = 'Param is Invalid';
                $res['msgCode'] = 6;
                http_response_code(200);
                echo json_encode($res);			
            }		
        } else {		
            http_response_code(405);
            echo json_encode($res);
        }
    } catch (Exception $e) {
        $res['code'] = 5;
        $res['msg'] = 'Internal Server Error: ' . $e->getMessage();
        $res['msgCode'] = 3;
        http_response_code(500);
        echo json_encode($res);
    }

    function withdrawUserBalance($userCode) {
        if (empty($userCode)) {
            throw new Exception('userCode is required');
        }

        $authToken = getAuthToken();
        $withdrawUrl = "https://dcyqv8f2id.com/api/v2/user/withdraw-all";

        $postData = [
            'userCode' => $userCode
        ];

        $ch = curl_init($withdrawUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $authToken,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200) {
            $responseData = json_decode($response, true);
            if (isset($responseData['success']) && $responseData['success']) {
                return $responseData;
            } else {
                throw new Exception('Withdraw failed: ' . ($responseData['message'] ?? 'Unknown error'));
            }
        } else {
            throw new Exception('Failed to withdraw. HTTP Code: ' . $httpCode . ' Response: ' . $response);
        }
    }

    function getAuthToken() {
        try {
            $authUrl = "https://dcyqv8f2id.com/api/v2/auth/createtoken";
            $postData = [
                'clientId' => 'top52-inr5',
                'clientSecret' => 'V1Umxk4UTEbKO3ZNJSt9bUAcw4LLKg1a'
            ];
    
            $ch = curl_init($authUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Accept: application/json'
            ]);
            curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
            // Log the request and response for debugging
            error_log('Auth Request Payload: ' . json_encode($postData));
            error_log('Auth Response: ' . $response);
            error_log('Auth HTTP Code: ' . $httpCode);
    
            if (curl_errno($ch)) {
                throw new Exception('Curl error: ' . curl_error($ch));
            }
            curl_close($ch);
    
            if ($httpCode == 200) {
                $data = json_decode($response, true);
                if (isset($data['token'])) {
                    return $data['token'];
                } else {
                    throw new Exception('Invalid token response format: ' . $response);
                }
            } else {
                throw new Exception('Failed to fetch auth token. HTTP Code: ' . $httpCode . ' Response: ' . $response);
            }
        } catch (Exception $e) {
            global $res;
            $res['code'] = 5;
            $res['msg'] = 'Auth Token Error: ' . $e->getMessage();
            $res['msgCode'] = 3;
            http_response_code(500);
            echo json_encode($res);
            exit;
        }
    }
?>